import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/home_screen.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/profile/profile_screen.dart';

import '../../screens/send_money_history/send_money_history_screen.dart';

import '../../screens/transection/transection_screen.dart';
import '../will_pop_widget.dart';
import 'nav_bar_item_widget.dart';

class BottomNavBar extends StatefulWidget {
  int currentIndex;

  BottomNavBar({Key? key, this.currentIndex = 0}) : super(key: key);

  @override
  State<BottomNavBar> createState() => _BottomNavBarState();
}

class _BottomNavBarState extends State<BottomNavBar> {
  List<Widget> screens = [const HomeScreen(), const TransactionScreen(), const SendMoneyHistory(), const ProfileScreen()];

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopWidget(
      child: Scaffold(
          body: screens[widget.currentIndex],
          bottomNavigationBar: SingleChildScrollView(
            physics: const ClampingScrollPhysics(),
            child: Container(
              width: MediaQuery.of(context).size.width,
              padding: const EdgeInsets.symmetric(vertical: Dimensions.space10),
              alignment: Alignment.center,
              decoration: const BoxDecoration(color: MyColor.colorWhite, boxShadow: [BoxShadow(color: Color.fromARGB(25, 0, 0, 0), offset: Offset(-2, -2), blurRadius: 2)]),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceAround,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  NavBarItem(
                      label: MyStrings.home.tr,
                      imagePath: MyImages.home,
                      index: 0,
                      isSelected: widget.currentIndex == 0,
                      press: () {
                        setState(() {
                          widget.currentIndex = 0;
                        });
                      }),
                  NavBarItem(
                      label: MyStrings.transaction.tr,
                      imagePath: MyImages.transactionSvg,
                      index: 1,
                      isSelected: widget.currentIndex == 1,
                      press: () {
                        setState(() {
                          widget.currentIndex = 1;
                        });
                      }),
                  NavBarItem(
                      label: MyStrings.sendHistory.tr,
                      imagePath: MyImages.historySvg,
                      index: 2,
                      isSelected: widget.currentIndex == 2,
                      press: () {
                        setState(() {
                          widget.currentIndex = 2;
                        });
                      }),
                  NavBarItem(
                      label: MyStrings.profile.tr,
                      imagePath: MyImages.profile,
                      index: 3,
                      isSelected: widget.currentIndex == 3,
                      press: () {
                        setState(() {
                          widget.currentIndex = 3;
                        });
                      }),
                ],
              ),
            ),
          )),
    );
  }
}
